function setFontSizeSelect() {
	if (typeof(Storage) !== "undefined") {
		switch (localStorage.bodyFontSize) {
			case "1.236em":
				document.getElementById("fontSizeSelect").selectedIndex = 0;
				break;
			case "1.382em":
				document.getElementById("fontSizeSelect").selectedIndex = 1;
				break;
			case "small":
				document.getElementById("fontSizeSelect").selectedIndex = 2;
				break;
			case "medium":
				document.getElementById("fontSizeSelect").selectedIndex = 3;
				break;
			case "large":
				document.getElementById("fontSizeSelect").selectedIndex = 4;
				break;
			case "x-large":
				document.getElementById("fontSizeSelect").selectedIndex = 5;
				break;
			case "xx-large":
				document.getElementById("fontSizeSelect").selectedIndex = 6;
				break;
		}
	}
}

function changeFontSize(selectTag) {
	if (typeof(Storage) !== "undefined") {
		if (selectTag.options[selectTag.selectedIndex].text == "☀️ default size") {
			localStorage.bodyFontSize = "1.236em";
		}
		else if (selectTag.options[selectTag.selectedIndex].text == "🌙 default size") {
			localStorage.bodyFontSize = "1.382em";
		}
		else {
			localStorage.bodyFontSize = selectTag.options[selectTag.selectedIndex].text;
		}

		document.body.style.fontSize = localStorage.bodyFontSize;
	}
}

// on page load
if (typeof(Storage) !== "undefined") { // check browser support for localStorage

	// Code for localStorage/sessionStorage.
	if (!localStorage.bodyFontSize) {
		if (localStorage.theme == "night") {
			localStorage.bodyFontSize = "1.382em";
		}
		else {
			localStorage.bodyFontSize = "1.236em";
		}
	}

	document.body.style.fontSize = localStorage.bodyFontSize;

	setFontSizeSelect();
}
