function setFontSizeSelect() {

	if (typeof(Storage) !== "undefined") {

		switch (localStorage.bodyFontSize) {

			case "1.236em":
				document.getElementById("fontSizeSelect").selectedIndex = 0;
				break;

			case "1.382em":
				document.getElementById("fontSizeSelect").selectedIndex = 1;
				break;

			case "small":
				document.getElementById("fontSizeSelect").selectedIndex = 2;
				break;

			case "medium":
				document.getElementById("fontSizeSelect").selectedIndex = 3;
				break;

			case "large":
				document.getElementById("fontSizeSelect").selectedIndex = 4;
				break;

			case "x-large":
				document.getElementById("fontSizeSelect").selectedIndex = 5;
				break;

			case "xx-large":
				document.getElementById("fontSizeSelect").selectedIndex = 6;
				break;

		}
	}
}

function setWidthsTo(fontSizeWidth) {

	document.getElementsByTagName("header")[0].style.width = fontSizeWidth;
	//document.getElementById("main").style.width = fontSizeWidth;
	//document.getElementsByTagName("nav")[0].style.width = fontSizeWidth;
	document.getElementById("ref").style.width = fontSizeWidth;
	document.getElementsByTagName("footer")[0].style.width = fontSizeWidth;

}

function setWidths() {

	if (typeof(Storage) !== "undefined") {

		// set margins and widths depending on
		// localStorage.bodyFontSize
		switch (localStorage.bodyFontSize) {

			// Day default
			case "1.236em":

				switch (true) {

					// iPhone 4 & 5 Portrait (320) & smaller
					case (window.innerWidth < 350):
						setWidthsTo("13em");
						break;

					// iPhone 6 Portrait (375)
					case (window.innerWidth >= 350) && (window.innerWidth < 400):
						setWidthsTo("15.5em");
						break;

					// iPhone 6 Plus Portrait (414)
					case (window.innerWidth >= 400) && (window.innerWidth < 450):
						setWidthsTo("18em");
						break;

					// iPhone 4 Landscape (480)
					case (window.innerWidth >= 450) && (window.innerWidth < 500):
						setWidthsTo("20.5em");
						break;

					case (window.innerWidth >= 500) && (window.innerWidth < 550):
						setWidthsTo("23em");
						break;

					// iPhone 5 Landscape (568)
					case (window.innerWidth >= 550) && (window.innerWidth < 600):
						setWidthsTo("25.5em");
						break;

					case (window.innerWidth >= 600) && (window.innerWidth < 650):
						setWidthsTo("28em");
						break;

					// iPhone 6 Landscape (667)
					//case (window.innerWidth >= 650) && (window.innerWidth < 700):
						//setWidthsTo("28.625em");
						//break;

					default:
						setWidthsTo(defaultWidth);
				}

				break;

			// Night default
			case "1.382em":

				switch (true) {

					// iPhone 4 & 5 Portrait (320) & smaller
					case (window.innerWidth < 350):
						setWidthsTo("12em");
						break;

					// iPhone 6 Portrait (375)
					case (window.innerWidth >= 350) && (window.innerWidth < 400):
						setWidthsTo("14.25em");
						break;

					// iPhone 6 Plus Portrait (414)
					case (window.innerWidth >= 400) && (window.innerWidth < 450):
						setWidthsTo("16.5em");
						break;

					// iPhone 4 Landscape (480)
					case (window.innerWidth >= 450) && (window.innerWidth < 500):
						setWidthsTo("18.75em");
						break;

					case (window.innerWidth >= 500) && (window.innerWidth < 550):
						setWidthsTo("21em");
						break;

					// iPhone 5 Landscape (568)
					case (window.innerWidth >= 550) && (window.innerWidth < 600):
						setWidthsTo("23.25em");
						break;

					case (window.innerWidth >= 600) && (window.innerWidth < 650):
						setWidthsTo("25.5em");
						break;

					// iPhone 6 Landscape (667)
					case (window.innerWidth >= 650) && (window.innerWidth < 700):
						setWidthsTo("27.75em");
						break;

					// iPhone 6 Plus Landscape (736)
					//case (window.innerWidth >= 700) && (window.innerWidth < 750):
						//setWidthsTo("30em");
						//break;

					default:
						setWidthsTo(defaultWidth);
				}

				break;

			case "small":

				switch (true) {

					// iPhone 4 & 5 Portrait (320) & smaller
					case (window.innerWidth < 350):
						setWidthsTo("20.75em");
						break;

					// iPhone 6 Portrait (375)
					case (window.innerWidth >= 350) && (window.innerWidth < 400):
						setWidthsTo("24.5em");
						break;

					// iPhone 6 Plus Portrait (414)
					case (window.innerWidth >= 400) && (window.innerWidth < 450):
						setWidthsTo("27em");
						break;

					// iPhone 4 Landscape (480)
						/*case (window.innerWidth >= 450) && (window.innerWidth < 500):
						setWidthsTo("18.75em");
						break;

					case (window.innerWidth >= 500) && (window.innerWidth < 550):
						setWidthsTo("21em");
						break;

					// iPhone 5 Landscape (568)
					case (window.innerWidth >= 550) && (window.innerWidth < 600):
						setWidthsTo("23.25em");
						break;

					case (window.innerWidth >= 600) && (window.innerWidth < 650):
						setWidthsTo("25.5em");
						break;

					// iPhone 6 Landscape (667)
					case (window.innerWidth >= 650) && (window.innerWidth < 700):
						setWidthsTo("27.75em");
						break;*/

					// iPhone 6 Plus Landscape (736)
					//case (window.innerWidth >= 700) && (window.innerWidth < 750):
						//setWidthsTo("30em");
						//break;

					default:
						setWidthsTo(defaultWidth);
				}

				break;

			case "medium":

				switch (true) {

					// iPhone 4 & 5 Portrait (320) & smaller
					case (window.innerWidth < 350):
						setWidthsTo("16.75em");
						break;

					// iPhone 6 Portrait (375)
					case (window.innerWidth >= 350) && (window.innerWidth < 400):
						setWidthsTo("19.75em");
						break;

					// iPhone 6 Plus Portrait (414)
					case (window.innerWidth >= 400) && (window.innerWidth < 450):
						setWidthsTo("22.25em");
						break;

					// iPhone 4 Landscape (480)
					case (window.innerWidth >= 450) && (window.innerWidth < 500):
						setWidthsTo("25.75em");
						break;

					case (window.innerWidth >= 500) && (window.innerWidth < 550):
						setWidthsTo("28.75em");
						break;

					// iPhone 5 Landscape (568)
						/*case (window.innerWidth >= 550) && (window.innerWidth < 600):
						setWidthsTo("23.25em");
						break;

					case (window.innerWidth >= 600) && (window.innerWidth < 650):
						setWidthsTo("25.5em");
						break;

					// iPhone 6 Landscape (667)
					case (window.innerWidth >= 650) && (window.innerWidth < 700):
						setWidthsTo("27.75em");
						break;*/

					// iPhone 6 Plus Landscape (736)
					//case (window.innerWidth >= 700) && (window.innerWidth < 750):
						//setWidthsTo("30em");
						//break;

					default:
						setWidthsTo(defaultWidth);
				}

				break;

			case "large":

				switch (true) {

					// iPhone 4 & 5 Portrait (320) & smaller
					case (window.innerWidth < 350):
						setWidthsTo("15em");
						break;

					// iPhone 6 Portrait (375)
					case (window.innerWidth >= 350) && (window.innerWidth < 400):
						setWidthsTo("17.75em");
						break;

					// iPhone 6 Plus Portrait (414)
					case (window.innerWidth >= 400) && (window.innerWidth < 450):
						setWidthsTo("20em");
						break;

					// iPhone 4 Landscape (480)
					case (window.innerWidth >= 450) && (window.innerWidth < 500):
						setWidthsTo("23.25em");
						break;

					case (window.innerWidth >= 500) && (window.innerWidth < 550):
						setWidthsTo("25.25em");
						break;

					// iPhone 5 Landscape (568)
					case (window.innerWidth >= 550) && (window.innerWidth < 600):
						setWidthsTo("28.75em");
						break;

					/*case (window.innerWidth >= 600) && (window.innerWidth < 650):
						setWidthsTo("25.5em");
						break;

					// iPhone 6 Landscape (667)
					case (window.innerWidth >= 650) && (window.innerWidth < 700):
						setWidthsTo("27.75em");
						break;*/

					// iPhone 6 Plus Landscape (736)
					//case (window.innerWidth >= 700) && (window.innerWidth < 750):
						//setWidthsTo("30em");
						//break;

					default:
						setWidthsTo(defaultWidth);
				}

				break;

			case "x-large":

				switch (true) {

					// iPhone 4 & 5 Portrait (320) & smaller
					case (window.innerWidth < 350):
						setWidthsTo("11em");
						break;

					// iPhone 6 Portrait (375)
					case (window.innerWidth >= 350) && (window.innerWidth < 400):
						setWidthsTo("13em");
						break;

					// iPhone 6 Plus Portrait (414)
					case (window.innerWidth >= 400) && (window.innerWidth < 450):
						setWidthsTo("14.5em");
						break;

					// iPhone 4 Landscape (480)
					case (window.innerWidth >= 450) && (window.innerWidth < 500):
						setWidthsTo("17em");
						break;

					case (window.innerWidth >= 500) && (window.innerWidth < 550):
						setWidthsTo("18.75em");
						break;

					// iPhone 5 Landscape (568)
					case (window.innerWidth >= 550) && (window.innerWidth < 600):
						setWidthsTo("21em");
						break;

					case (window.innerWidth >= 600) && (window.innerWidth < 650):
						setWidthsTo("23em");
						break;

					// iPhone 6 Landscape (667)
					case (window.innerWidth >= 650) && (window.innerWidth < 700):
						setWidthsTo("25em");
						break;

					// iPhone 6 Plus Landscape (736)
					case (window.innerWidth >= 700) && (window.innerWidth < 750):
						setWidthsTo("27.5em");
						break;

					// iPad Air Portrait (768)
					case (window.innerWidth >= 750) && (window.innerWidth < 800):
						setWidthsTo("29em");
						break;

					default:
						setWidthsTo(defaultWidth);
				}

				break;

			case "xx-large":

				switch (true) {

					// iPhone 4 & 5 Portrait (320) & smaller
					case (window.innerWidth < 350):
						setWidthsTo("7.5em");
						break;

					// iPhone 6 Portrait (375)
					case (window.innerWidth >= 350) && (window.innerWidth < 400):
						setWidthsTo("9em");
						break;

					// iPhone 6 Plus Portrait (414)
					case (window.innerWidth >= 400) && (window.innerWidth < 450):
						setWidthsTo("10.5em");
						break;

					// iPhone 4 Landscape (480)
					case (window.innerWidth >= 450) && (window.innerWidth < 500):
						setWidthsTo("12em");
						break;

					case (window.innerWidth >= 500) && (window.innerWidth < 550):
						setWidthsTo("13.5em");
						break;

					// iPhone 5 Landscape (568)
					case (window.innerWidth >= 550) && (window.innerWidth < 600):
						setWidthsTo("15em");
						break;

					case (window.innerWidth >= 600) && (window.innerWidth < 650):
						setWidthsTo("16.5em");
						break;

					// iPhone 6 Landscape (667)
					case (window.innerWidth >= 650) && (window.innerWidth < 700):
						setWidthsTo("18em");
						break;

					// iPhone 6 Plus Landscape (736)
					case (window.innerWidth >= 700) && (window.innerWidth < 750):
						setWidthsTo("19.5em");
						break;

					// iPad Air Portrait (768)
					case (window.innerWidth >= 750) && (window.innerWidth < 800):
						setWidthsTo("21em");
						break;

					case (window.innerWidth >= 800) && (window.innerWidth < 850):
						setWidthsTo("22.5em");
						break;

					case (window.innerWidth >= 850) && (window.innerWidth < 900):
						setWidthsTo("24em");
						break;

					case (window.innerWidth >= 900) && (window.innerWidth < 950):
						setWidthsTo("25.5em");
						break;

					case (window.innerWidth >= 950) && (window.innerWidth < 1000):
						setWidthsTo("27em");
						break;

					// iPad Air Landscape (1024)
					case (window.innerWidth >= 1000) && (window.innerWidth < 1050):
						setWidthsTo("28.5em");
						break;

					default:
						setWidthsTo(defaultWidth);
				}

				break;

		}
	}
}

function delayedSetWidths() {
	setTimeout(setWidths, 100)
}

function changeFontSize(selectTag) {

	if (typeof(Storage) !== "undefined") {

		// set localStorage.bodyFontSize according to selected value
		if (selectTag.options[selectTag.selectedIndex].text == "☀️ default size") {
			localStorage.bodyFontSize = "1.236em";
		}
		else if (selectTag.options[selectTag.selectedIndex].text == "🌙 default size") {
			localStorage.bodyFontSize = "1.382em";
		}
		else {
			localStorage.bodyFontSize = selectTag.options[selectTag.selectedIndex].text;
		}

		setWidths();

		document.body.style.fontSize = localStorage.bodyFontSize;

	}
}

// on page load
if (typeof(Storage) !== "undefined") { // check browser support for localStorage

	// if necessary, initialize localStorage.bodyFontSize
	if (!localStorage.bodyFontSize) {
		if (localStorage.theme == "night") {
			localStorage.bodyFontSize = "1.382em";
		}
		else {
			localStorage.bodyFontSize = "1.236em";
		}
	}

	var defaultWidth = "30em";

	setWidths();

	document.body.style.fontSize = localStorage.bodyFontSize;

	setFontSizeSelect();

	window.addEventListener("resize", delayedSetWidths);

}
